# 通知設計書 8-Download failed!

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるダウンロード失敗通知「Download failed!」の設計仕様を定義する。この通知は、StaxRipUpdateでファイルのダウンロードが失敗した際に表示されるエラー通知である。

### 本通知の処理概要

Download failed!通知は、更新ファイルのダウンロードが失敗したことをユーザーに伝達するためのエラー通知メカニズムである。

**業務上の目的・背景**：アプリケーションの更新プロセスにおいて、ダウンロードフェーズで問題が発生したことをユーザーに明確に伝える。ネットワークエラー、サーバーエラー、タイムアウトなど様々な原因でダウンロードが失敗する可能性があり、ユーザーはこの通知を受けて再試行やネットワーク状況の確認を行うことができる。

**通知の送信タイミング**：非同期ダウンロード処理のコールバック（AsyncCompletedEventArgs）で、ダウンロードがキャンセルされているか、またはエラーが発生した場合に表示される。

**通知の受信者**：アプリケーションの更新を実行しているユーザー。

**通知内容の概要**：「Download failed!」というエラーメッセージがMsgError形式で表示される。Errorアイコン（赤い×マーク）とOKボタン、コピーボタンが配置される。

**期待されるアクション**：ユーザーはダウンロード失敗を確認し、OKボタンをクリックしてダイアログを閉じる。その後、ネットワーク接続を確認して再度ダウンロードを試みるか、手動でファイルをダウンロードする。

## 通知種別

アプリ内通知（タスクダイアログ/MsgError）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コールバック内で表示） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

ダウンロードを開始したフォームまたはメインウィンドウのオーナーとして表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
Download failed!

[コンテンツ]
（なし - titleのみ表示）

[アイコン]
Error（赤い×アイコン）

[ボタン]
OK

[リンクボタン]
Copy Message（クリックでメッセージをクリップボードにコピー）
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ/非同期処理 | OnDownloadComplete | e.Cancelled = True Or e.Error IsNot Nothing | ダウンロード完了コールバックで失敗時に表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| e.Cancelled = False And e.Error Is Nothing | ダウンロードが成功した場合は表示しない（代わりにMsgInfoで"Download succeeded!"を表示） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ダウンロード開始] --> B[非同期ダウンロード処理]
    B --> C[OnDownloadComplete コールバック]
    C --> D{e.Cancelled?}
    D -->|Yes| G[MsgError Download failed!]
    D -->|No| E{e.Error?}
    E -->|IsNot Nothing| G
    E -->|Is Nothing| F[MsgInfo Download succeeded!]
    G --> H[ダイアログ表示]
    H --> I{ユーザー操作}
    I -->|OK| J[ダイアログクローズ]
    I -->|Copy Message| K[クリップボードコピー]
    K --> I
    J --> L[終了]
    F --> M[成功処理]
    M --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（Download failed!はデータベースを参照しない）

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし（Download failed!は送信ログを記録しない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネットワークエラー | 接続タイムアウト、DNSエラー等 | MsgErrorで通知、ユーザーによる再試行 |
| サーバーエラー | HTTPステータス4xx/5xx | MsgErrorで通知、後で再試行 |
| ユーザーキャンセル | ダウンロード中断 | MsgErrorで通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし、ユーザーによる手動再試行） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（ダウンロード失敗時に即座に表示）

## セキュリティ考慮事項

- エラーメッセージに詳細なエラー情報（例外スタックトレース等）は含まれない
- コピーボタンでエラーメッセージをコピー可能（サポート問い合わせ用）

## 備考

- StaxRipUpdate.OnDownloadComplete()内で使用される
- ToolUpdate.Download()では別のメッセージ（"Download was canceled or failed."）が使用される
- エラーの詳細情報は含まれず、シンプルな失敗通知のみ

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ダウンロード完了イベントで使用されるAsyncCompletedEventArgsを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | AsyncCompletedEventArgsのCancelled/Errorプロパティ使用（行144-150） |

**読解のコツ**: e.Cancelledがtrueの場合、またはe.ErrorがNothingでない場合は失敗と判定される。

#### Step 2: エントリーポイントを理解する

OnDownloadComplete()コールバック関数の失敗ハンドリングを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | OnDownloadComplete関数の定義（行144-150） |

**主要処理フロー**:
1. **行144**: Shared Sub OnDownloadComplete(sender, e As AsyncCompletedEventArgs)
2. **行145**: Not e.Cancelled AndAlso e.Error Is Nothing の条件チェック
3. **行147**: Else節 - 条件を満たさない場合
4. **行148**: MsgError("Download failed!") - 失敗時の通知

#### Step 3: MsgError呼び出しを理解する

MsgErrorがどのようにダイアログを表示するかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgError関数の定義（行1222-1240） |

**主要処理フロー**:
- **行1222-1240**: MsgError関数がTaskDialog(Of String)を生成
- TaskIcon.Error, ShowCopyButton = True でダイアログを表示

### プログラム呼び出し階層図

```
[ダウンロード開始]
    |
    +-- WebClient.DownloadFileAsync() または HttpClient
           |
           +-- [非同期ダウンロード処理]
                  |
                  +-- [失敗/キャンセル発生]
                         |
                         +-- OnDownloadComplete(sender, e)  [StaxRipUpdate.vb:144]
                                |
                                +-- e.Cancelled = True または e.Error IsNot Nothing
                                |
                                +-- MsgError("Download failed!")  [StaxRipUpdate.vb:148]
                                       |
                                       +-- MsgError()  [General.vb:1226]
                                              |
                                              +-- TaskDialog(Of String) 生成
                                              +-- Icon = TaskIcon.Error
                                              +-- ShowCopyButton = True
                                              +-- AddButton("OK")
                                              +-- Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

ダウンロード処理 ──> 失敗/キャンセル発生 ──> イベント通知
                           |
AsyncCompleted ──────> OnDownloadComplete() ──> イベント受信
EventArgs                  |
    |                      |
    +-- Cancelled ───> True ─────────────────> MsgError表示
    +-- Error ───────> IsNot Nothing ────────> MsgError表示
                           |
                     MsgError呼び出し ───────> [画面表示]
                           |
               "Download failed!" ──────────> エラーダイアログ
                           |                       |
                           |              +-- Errorアイコン
                           |              +-- OKボタン
                           |              +-- Copy Messageボタン
                           |
                       OKクリック ──────────> [クローズ]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| StaxRipUpdate.vb | `Source/General/StaxRipUpdate.vb` | ソース | OnDownloadComplete関数、ダウンロード失敗通知の発生元 |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | 実際のダイアログ表示処理、ShowCopyButtonプロパティ |
| DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ソース | ダウンロード進捗表示フォーム |
